﻿Partial Public Class MainPage
    Inherits PhoneApplicationPage

    ' Constructor
    Public Sub New()
        InitializeComponent()

        redSlider.Value = 128
        greenSlider.Value = 128
        blueSlider.Value = 128
    End Sub


    Private Sub OnSliderValueChanged(ByVal sender As Object, ByVal args As RoutedPropertyChangedEventArgs(Of Double))
        Dim clr As Color = Color.FromArgb(255, CByte(redSlider.Value),
                                               CByte(greenSlider.Value),
                                               CByte(blueSlider.Value))

        rect.Fill = New SolidColorBrush(clr)

        redText.Text = clr.R.ToString("X2")
        greenText.Text = clr.G.ToString("X2")
        blueText.Text = clr.B.ToString("X2")
    End Sub


    Protected Overrides Sub OnOrientationChanged(ByVal args As OrientationChangedEventArgs)
        ContentPanel.RowDefinitions.Clear()
        ContentPanel.ColumnDefinitions.Clear()

        ' Landscape
        If (args.Orientation And PageOrientation.Landscape) <> 0 Then
            Dim coldef As New ColumnDefinition()
            coldef.Width = New GridLength(1, GridUnitType.Star)
            ContentPanel.ColumnDefinitions.Add(coldef)

            coldef = New ColumnDefinition()
            coldef.Width = New GridLength(1, GridUnitType.Star)
            ContentPanel.ColumnDefinitions.Add(coldef)

            Grid.SetRow(controlGrid, 0)
            Grid.SetColumn(controlGrid, 1)
            ' Portrait
        Else
            Dim rowdef As New RowDefinition()
            rowdef.Height = New GridLength(1, GridUnitType.Star)
            ContentPanel.RowDefinitions.Add(rowdef)

            rowdef = New RowDefinition()
            rowdef.Height = New GridLength(1, GridUnitType.Star)
            ContentPanel.RowDefinitions.Add(rowdef)

            Grid.SetRow(controlGrid, 1)
            Grid.SetColumn(controlGrid, 0)
        End If
        MyBase.OnOrientationChanged(args)
    End Sub
End Class
